<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Obtener el siguiente código interno para la denominación
    $sql_codigo = "SELECT COALESCE(MAX(codigo_interno), 0) + 1 as siguiente_codigo 
                   FROM bienes 
                   WHERE denominacion_id = ?";
    $stmt = $db->prepare($sql_codigo);
    $stmt->execute([$input['denominacion_id']]);
    $result = $stmt->fetch();
    $codigo_interno = $result['siguiente_codigo'];
    
    // Insertar el nuevo bien
    $sql_insert = "
        INSERT INTO bienes (
            denominacion_id, 
            descripcion_individual, 
            codigo_interno, 
            estado_id, 
            clase_id, 
            ubicacion_id, 
            responsable_id, 
            observaciones
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ";
    
    $stmt = $db->prepare($sql_insert);
    $success = $stmt->execute([
        $input['denominacion_id'],
        $input['descripcion_individual'] ?? null,
        $codigo_interno,
        $input['estado_id'],
        $input['clase_id'] ?? null,
        $input['ubicacion_id'] ?? null,
        $input['responsable_id'] ?? null,
        $input['observaciones'] ?? null
    ]);
    
    if ($success) {
        echo json_encode([
            'success' => true,
            'message' => 'Bien registrado exitosamente',
            'id' => $db->lastInsertId(),
            'codigo_interno' => $codigo_interno
        ]);
    } else {
        throw new Exception('Error al insertar el bien');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al insertar bien: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>