<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['nombreArchivo']) || !isset($input['rutaLocal'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Crear tabla de reportes si no existe
    $createTable = "
        CREATE TABLE IF NOT EXISTS reportes_pdf (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nombre_archivo VARCHAR(255) NOT NULL,
            ruta_local TEXT NOT NULL,
            fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            fecha_generacion INT NOT NULL
        )
    ";
    $db->exec($createTable);
    
    // Insertar el nuevo reporte
    $sql = "INSERT INTO reportes_pdf (nombre_archivo, ruta_local, fecha_generacion) VALUES (?, ?, ?)";
    $stmt = $db->prepare($sql);
    $success = $stmt->execute([
        $input['nombreArchivo'],
        $input['rutaLocal'],
        isset($input['fechaCreacion']) ? $input['fechaCreacion'] : time()
    ]);
    
    if ($success) {
        $nuevoId = $db->lastInsertId();
        echo json_encode([
            'success' => true,
            'message' => 'Reporte guardado exitosamente',
            'id' => $nuevoId
        ]);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error al guardar reporte']);
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error de base de datos: ' . $e->getMessage()
    ]);
}
?>