<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['id'])) {
        echo json_encode([
            'success' => false,
            'message' => 'El ID del grupo es requerido'
        ]);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Verificar si el grupo tiene clases asociadas
    $sql_check = "SELECT COUNT(*) as count FROM clases WHERE grupo_id = ?";
    $stmt = $db->prepare($sql_check);
    $stmt->execute([$input['id']]);
    $result = $stmt->fetch();
    
    if ($result['count'] > 0) {
        echo json_encode([
            'success' => false,
            'message' => 'No se puede eliminar el grupo porque tiene clases asociadas'
        ]);
        exit();
    }
    
    // Eliminar el grupo
    $sql_delete = "DELETE FROM grupos WHERE id = ?";
    
    $stmt = $db->prepare($sql_delete);
    $success = $stmt->execute([$input['id']]);
    
    if ($success && $stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Grupo eliminado exitosamente'
        ]);
    } else if ($stmt->rowCount() == 0) {
        echo json_encode([
            'success' => false,
            'message' => 'No se encontró el grupo a eliminar'
        ]);
    } else {
        throw new Exception('Error al eliminar el grupo');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al eliminar grupo: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>