<?php
require_once 'conexion.php';

try {
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "SELECT id, nombre, dni, correo, celular FROM responsables ORDER BY nombre";
    
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $responsables = $stmt->fetchAll();
    
    echo json_encode($responsables, JSON_UNESCAPED_UNICODE);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al consultar responsables: ' . $e->getMessage()
    ]);
}
?>