<?php
require_once 'conexion.php';

try {
    $responsable_id = $_GET['responsable_id'] ?? 0;
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "
        SELECT 
            b.id,
            d.codigo_patrimonial,
            b.codigo_interno,
            CONCAT(d.codigo_patrimonial, '-', LPAD(b.codigo_interno, 4, '0')) as codigo_completo,
            d.denominacion,
            e.nombre as estado,
            e.descripcion as descripcion_estado,
            c.nombre as clase,
            g.nombre as grupo,
            u.nombre as ubicacion,
            r.nombre as responsable,
            b.observaciones,
            DATE_FORMAT(b.fecha_registro, '%d/%m/%Y %H:%i') as fecha_registro
        FROM bienes b
        INNER JOIN denominaciones d ON b.denominacion_id = d.id
        INNER JOIN estados e ON b.estado_id = e.id
        LEFT JOIN clases c ON b.clase_id = c.id
        LEFT JOIN grupos g ON c.grupo_id = g.id
        LEFT JOIN ubicaciones u ON b.ubicacion_id = u.id
        LEFT JOIN responsables r ON b.responsable_id = r.id
        WHERE r.id = ?
        ORDER BY b.id DESC
    ";
    
    $stmt = $db->prepare($sql);
    $stmt->execute([$responsable_id]);
    $bienes = $stmt->fetchAll();
    
    echo json_encode($bienes, JSON_UNESCAPED_UNICODE);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al consultar bienes por responsable: ' . $e->getMessage()
    ]);
}
?>