<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['id']) || !isset($input['nombre'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'ID y nombre requeridos']);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "UPDATE ubicaciones SET nombre = ? WHERE id = ?";
    $stmt = $db->prepare($sql);
    $success = $stmt->execute([$input['nombre'], $input['id']]);
    
    if ($success && $stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Ubicación actualizada exitosamente'
        ]);
    } else {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'message' => 'Ubicación no encontrada'
        ]);
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>