<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['id'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'ID requerido']);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "UPDATE responsables SET nombre = ?, dni = ?, correo = ?, celular = ? WHERE id = ?";
    $stmt = $db->prepare($sql);
    $success = $stmt->execute([
        $input['nombre'],
        $input['dni'] ?? null,
        $input['correo'] ?? null,
        $input['celular'] ?? null,
        $input['id']
    ]);
    
    if ($success && $stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Responsable actualizado exitosamente'
        ]);
    } else {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'message' => 'Responsable no encontrado'
        ]);
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>