<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['id']) || empty($input['nombre'])) {
        echo json_encode([
            'success' => false,
            'message' => 'El ID y nombre del grupo son requeridos'
        ]);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Actualizar el grupo
    $sql_update = "UPDATE grupos SET nombre = ? WHERE id = ?";
    
    $stmt = $db->prepare($sql_update);
    $success = $stmt->execute([$input['nombre'], $input['id']]);
    
    if ($success && $stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Grupo actualizado exitosamente'
        ]);
    } else if ($stmt->rowCount() == 0) {
        echo json_encode([
            'success' => false,
            'message' => 'No se encontró el grupo a actualizar'
        ]);
    } else {
        throw new Exception('Error al actualizar el grupo');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al actualizar grupo: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>