<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['id']) || empty($input['nombre']) || empty($input['grupo_id'])) {
        echo json_encode([
            'success' => false,
            'message' => 'El ID, nombre de la clase y el grupo son requeridos'
        ]);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Verificar que el grupo existe
    $sql_check = "SELECT COUNT(*) as count FROM grupos WHERE id = ?";
    $stmt = $db->prepare($sql_check);
    $stmt->execute([$input['grupo_id']]);
    $result = $stmt->fetch();
    
    if ($result['count'] == 0) {
        echo json_encode([
            'success' => false,
            'message' => 'El grupo seleccionado no existe'
        ]);
        exit();
    }
    
    // Actualizar la clase
    $sql_update = "UPDATE clases SET nombre = ?, grupo_id = ? WHERE id = ?";
    
    $stmt = $db->prepare($sql_update);
    $success = $stmt->execute([$input['nombre'], $input['grupo_id'], $input['id']]);
    
    if ($success && $stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Clase actualizada exitosamente'
        ]);
    } else if ($stmt->rowCount() == 0) {
        echo json_encode([
            'success' => false,
            'message' => 'No se encontró la clase a actualizar'
        ]);
    } else {
        throw new Exception('Error al actualizar la clase');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al actualizar clase: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>